<?php
include 'conexion.php';

// 1. Verificamos que nos hayan pasado un ID en la URL (ej: detalle.php?id=EXO-202510-001)
if(isset($_GET['id'])) {
    $id_tour = $_GET['id'];
    
    // --- CONSULTA 1: DATOS GENERALES (CATÁLOGO) ---
    // Usamos comillas simples '$id_tour' porque el ID contiene letras y guiones
    $sql_tour = "SELECT * FROM tours_maestros WHERE ID_PAQUETE = '$id_tour'";
    $result_tour = $conn->query($sql_tour);

    if ($result_tour->num_rows > 0) {
        $tour = $result_tour->fetch_assoc();
        
        // Preparamos los datos visuales
        $lista_incluye = explode(',', $tour['INCLUYE']); // Convertimos texto en lista
        $imagen = !empty($tour['IMAGEN_RUTA']) ? $tour['IMAGEN_RUTA'] : 'img/default.jpg';
        
    } else {
        die("<div class='container mt-5'><h1>Error: Paquete no encontrado.</h1><a href='tours.php' class='btn btn-primary'>Volver</a></div>");
    }

    // --- CONSULTA 2: DETALLE DÍA POR DÍA ---
    // Traemos los días ordenados numéricamente (1, 2, 3...)
    $sql_itinerario = "SELECT * FROM itinerariosDetalle WHERE ID_PAQUETE = '$id_tour' ORDER BY DIA ASC";
    $result_itinerario = $conn->query($sql_itinerario);

} else {
    die("Error: Faltan datos.");
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $tour['NOMBRE_PAQUETE']; ?> - Detalles</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold fs-3 d-flex align-items-center" href="index.php">
                <img src="img/logo1.png" alt="Logo" style="height: 50px; width: auto;" class="me-2">
                <span>Neural<span class="text-primary">Traveler</span></span>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="tours.php">Volver a Tours</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <header class="position-relative" style="height: 50vh; min-height: 400px;">
        <img src="<?php echo $imagen; ?>" onerror="this.src='img/default.jpg'" class="w-100 h-100 object-fit-cover" style="filter: brightness(0.5);">
        
        <div class="position-absolute top-50 start-50 translate-middle text-center text-white w-100 px-3">
            <span class="badge bg-warning text-dark mb-2"><?php echo $tour['CATEGORIA_VIAJE']; ?></span>
            <h1 class="display-4 fw-bold"><?php echo $tour['NOMBRE_PAQUETE']; ?></h1>
            <p class="lead"><i class="fas fa-map-marker-alt"></i> <?php echo $tour['DESTINO_PRINCIPAL']; ?></p>
        </div>
    </header>

    <section class="container py-5">
        <div class="row g-5">
            
            <div class="col-lg-8">
                
                <div class="mb-5">
                    <h3 class="fw-bold text-primary mb-3">Resumen del Viaje</h3>
                    <p class="lead text-muted"><?php echo $tour['DESCRIPCION_IA']; ?></p>
                </div>

                <h3 class="fw-bold text-primary mb-4"><i class="fas fa-route"></i> Itinerario Detallado</h3>
                
                <?php if ($result_itinerario->num_rows > 0) { ?>
                    
                    <div class="accordion shadow-sm" id="accordionItinerario">
                        <?php 
                        $contador = 0;
                        while($dia = $result_itinerario->fetch_assoc()) { 
                            $contador++;
                            // Hacemos que el Día 1 aparezca abierto por defecto (clase 'show')
                            $isOpen = ($contador == 1) ? 'show' : '';
                            $isCollapsed = ($contador == 1) ? '' : 'collapsed';
                        ?>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading<?php echo $contador; ?>">
                                    <button class="accordion-button <?php echo $isCollapsed; ?> fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $contador; ?>">
                                        <span class="badge bg-primary me-3">DÍA <?php echo $dia['DIA']; ?></span> 
                                        <?php echo $dia['TITULO']; ?>
                                    </button>
                                </h2>
                                <div id="collapse<?php echo $contador; ?>" class="accordion-collapse collapse <?php echo $isOpen; ?>" data-bs-parent="#accordionItinerario">
                                    <div class="accordion-body text-secondary">
                                        <?php echo nl2br($dia['DESCRIPCION']); ?>
                                    </div>
                                </div>
                            </div>

                        <?php } // Fin del While ?>
                    </div>

                <?php } else { ?>
                    <div class="alert alert-warning">
                        El itinerario detallado de este paquete se está cargando. Contacta con nosotros para más info.
                    </div>
                <?php } ?>

            </div>

            <div class="col-lg-4">
                <div class="card shadow border-0 position-sticky" style="top: 100px; z-index: 10;">
                    <div class="card-body p-4">
                        <small class="text-muted">Precio por persona desde</small>
                        <h2 class="fw-bold text-primary mb-3">
                            $<?php echo number_format($tour['PRECIO_BASE']); ?> <?php echo $tour['MONEDA']; ?>
                        </h2>
                        
                        <div class="d-flex justify-content-between mb-2">
                            <span><i class="far fa-clock text-primary"></i> Duración:</span>
                            <strong><?php echo $tour['DURACION_DIAS']; ?> Días</strong>
                        </div>
                        <hr>
                        
                        <h6 class="fw-bold mb-3">Tu paquete incluye:</h6>
                        <ul class="list-unstyled mb-4 small">
                            <?php foreach($lista_incluye as $item) { ?>
                                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> <?php echo trim($item); ?></li>
                            <?php } ?>
                        </ul>

                        <div class="d-grid gap-2">
                            <button class="btn btn-primary btn-lg rounded-pill fw-bold">Solicitar Reserva</button>
                            <a href="https://wa.me/527207181513?text=Me interesa el tour <?php echo $tour['NOMBRE_PAQUETE']; ?>" target="_blank" class="btn btn-outline-success rounded-pill">
                                <i class="fab fa-whatsapp"></i> Contactar por WhatsApp
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

<?php include 'footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>