<?php include 'conexion.php'; ?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NeuralTraveler - Inicio</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold fs-3 d-flex align-items-center" href="index.php">
            <img src="img/logo1.png" alt="Logo" height="50" class="me-2">
            <div>Neural<span class="text-primary">Traveler</span></div>
        </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link active" href="index.php">Home</a></li>
                    <li class="nav-item">
                        <a class="nav-link" href="tours.php">Tours</a>
                    </li>                   
                    <li class="nav-item ms-lg-3">
                        <a href="tours.php" class="btn btn-outline-primary rounded-pill px-4">Ver Catálogo</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <header class="hero-banner d-flex align-items-center text-white text-center" style="background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('img/banner.jpg') no-repeat center center/cover; min-height: 600px;">
        <div class="container">
            <h1 class="display-3 fw-bold mb-3">Explora el mundo con <br> NeuralTraveler</h1>
            <p class="lead mb-4">Descubre lugares increíbles y vive experiencias inolvidables.</p>
            <a href="tours.php" class="btn btn-primary btn-lg rounded-pill px-5">Explorar ahora</a>
        </div>
    </header>

    <div class="container search-wrapper" style="margin-top: -50px; position: relative; z-index: 10;">
        <div class="card border-0 shadow p-4 search-card">
            <form action="tours.php" method="GET">
                <div class="row g-3 align-items-end">
                    <div class="col-md-10">
                        <label for="destino" class="form-label fw-bold"><i class="fas fa-map-marker-alt text-primary"></i> ¿A dónde quieres ir?</label>
                        <input type="text" name="busqueda" class="form-control form-control-lg" placeholder="Ej: Japón, Perú, Playa...">
                    </div>
                    <div class="col-md-2 d-grid">
                        <button type="submit" class="btn btn-primary btn-lg fw-bold">Buscar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Destinos Populares</h2>
                <p class="text-muted">Nuestras últimas incorporaciones.</p>
            </div>

            <div class="row g-4" id="cards-container">
                
                <?php
                // CONSULTA: Traemos solo 3 tours aleatorios (o los más nuevos) para la portada
                $sql_home = "SELECT * FROM tours_maestros WHERE ESTATUS = 'Estructurado' ORDER BY RAND() LIMIT 3";
                $result_home = $conn->query($sql_home);

                if ($result_home->num_rows > 0) {
                    while($row = $result_home->fetch_assoc()) {
                        $imagen = !empty($row['IMAGEN_RUTA']) ? $row['IMAGEN_RUTA'] : 'img/default.jpg';
                ?>
                
                <div class="col-md-4 destination-card">
                    <div class="card h-100 border-0 shadow-sm overflow-hidden hover-effect">
                        <div class="position-relative">
                            <img src="<?php echo $imagen; ?>" onerror="this.src='img/default.jpg';" class="card-img-top" alt="Tour" style="height: 250px; object-fit: cover;">
                            <span class="position-absolute bottom-0 start-0 bg-primary text-white px-3 py-1 m-3 rounded-pill fw-bold">
                                $<?php echo number_format($row['PRECIO_BASE']); ?> <?php echo $row['MONEDA']; ?>
                            </span>
                        </div>
                        <div class="card-body">
                            <div class="text-warning small mb-2">
                                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                            </div>
                            <h5 class="card-title fw-bold"><?php echo $row['NOMBRE_PAQUETE']; ?></h5>
                            <p class="card-text location text-muted">
                                <i class="fas fa-map-marker-alt me-1 text-danger"></i> <?php echo $row['DESTINO_PRINCIPAL']; ?>
                            </p>
                            <a href="detalle.php?id=<?php echo $row['ID_PAQUETE']; ?>" class="btn btn-outline-primary w-100 rounded-pill mt-2">Ver Detalles</a>
                        </div>
                    </div>
                </div>

                <?php 
                    } 
                } else {
                    echo "<p class='text-center'>Cargando destinos increíbles...</p>";
                }
                ?>

            </div>
            
            <div class="text-center mt-5">
                <a href="tours.php" class="btn btn-outline-dark rounded-pill px-5">Ver todos los paquetes</a>
            </div>
        </div>
    </section>
    
<?php include 'footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>