// 1. Seleccionamos los elementos
const inputDestino = document.getElementById('destino');
const botonBuscar = document.querySelector('.btn-search');
// IMPORTANTE: Seleccionamos la columna que tiene la clase 'destination-card'
const tarjetas = document.querySelectorAll('.destination-card');

function filtrarTarjetas() {
    const textoBusqueda = inputDestino.value.toLowerCase();

    tarjetas.forEach(tarjeta => {
        // 2. CAMBIO AQUÍ: Buscamos por la clase de Bootstrap '.card-title'
        // Usamos el operador ?. por si acaso no encuentra el elemento, que no de error
        const tituloElemento = tarjeta.querySelector('.card-title');
        const ubicacionElemento = tarjeta.querySelector('.location');

        // Obtenemos el texto solo si el elemento existe
        const titulo = tituloElemento ? tituloElemento.textContent.toLowerCase() : '';
        const ubicacion = ubicacionElemento ? ubicacionElemento.textContent.toLowerCase() : '';

        // 3. Comparamos
        if (titulo.includes(textoBusqueda) || ubicacion.includes(textoBusqueda)) {
            // Si coincide, quitamos cualquier estilo inline para que se muestre normal
            tarjeta.style.display = ''; 
        } else {
            // Si no coincide, lo ocultamos
            tarjeta.style.display = 'none';
        }
    });
}

// Eventos
inputDestino.addEventListener('keyup', filtrarTarjetas);

botonBuscar.addEventListener('click', (e) => {
    e.preventDefault();
    filtrarTarjetas();
});


// ... Todo tu código anterior ...

// NUEVA FUNCIÓN: Para conectar el menú con el buscador
function buscarDesdeMenu(lugar) {
    // 1. Ponemos el texto en la caja de búsqueda
    inputDestino.value = lugar;
    
    // 2. Ejecutamos el filtro manualmente (reutilizamos tu función)
    filtrarTarjetas();
    
    // 3. (Opcional) Hacemos scroll suave hacia las tarjetas para que el usuario vea el resultado
    const contenedorTarjetas = document.getElementById('cards-container');
    // Restamos un poco (100px) para que no quede pegado al borde superior
    const posicion = contenedorTarjetas.getBoundingClientRect().top + window.scrollY - 150;
    
    window.scrollTo({
        top: posicion,
        behavior: 'smooth'
    });
}