<?php include 'conexion.php'; ?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Catálogo de Viajes - NeuralTraveler</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css"> 
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold fs-3 d-flex align-items-center" href="index.php">
                <img src="img/logo1.png" alt="Logo" style="height: 50px; width: auto;" class="me-2">
                <span>Neural<span class="text-primary">Traveler</span></span>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                    <li class="nav-item"><a class="nav-link active text-primary fw-bold" href="tours.php">Tours</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="bg-primary text-white text-center py-5 mb-5">
        <div class="container">
            <h1 class="fw-bold">Explora el Mundo</h1>
            <p class="lead">Nuestra selección de experiencias inolvidables</p>
        </div>
    </div>

    <section class="container pb-5">
        
        <?php
        // LOGICA DE BÚSQUEDA
        $where = "WHERE ESTATUS = 'Estructurado'"; // Condición base

        // Verificamos si alguien escribió en el buscador (viene por la URL ?busqueda=apon)
        if (isset($_GET['busqueda']) && !empty($_GET['busqueda'])) {
            $busqueda = $conn->real_escape_string($_GET['busqueda']);
            // Agregamos el filtro a la consulta SQL
            $where .= " AND (NOMBRE_PAQUETE LIKE '%$busqueda%' OR DESTINO_PRINCIPAL LIKE '%$busqueda%' OR CATEGORIA_VIAJE LIKE '%$busqueda%')";
            
            echo "<div class='alert alert-light text-center mb-4'>Mostrando resultados para: <strong>" . htmlspecialchars($_GET['busqueda']) . "</strong> <a href='tours.php' class='text-danger ms-2'><i class='fas fa-times'></i> Limpiar filtro</a></div>";
        }

        // CONSULTA FINAL CON O SIN FILTRO
        $sql = "SELECT * FROM tours_maestros $where";
        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $imagen = !empty($row['IMAGEN_RUTA']) ? $row['IMAGEN_RUTA'] : 'img/default.jpg';
        ?>

            <div class="card mb-5 border-0 shadow overflow-hidden hover-effect">
                <div class="row g-0">
                    <div class="col-md-4 d-flex flex-column position-relative">
                        <img src="<?php echo $imagen; ?>" onerror="this.src='img/default.jpg';" class="img-fluid h-100 w-100" style="object-fit: cover; min-height: 300px;">
                        
                        <div class="bg-dark text-white text-center py-3 position-absolute bottom-0 w-100 opacity-75">
                            <span class="fs-4 fw-bold text-warning">$<?php echo number_format($row['PRECIO_BASE']); ?> <?php echo $row['MONEDA']; ?></span>
                        </div>
                    </div>
                    
                    <div class="col-md-8">
                        <div class="card-body p-4 p-lg-5">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h2 class="card-title fw-bold text-primary mb-0"><?php echo $row['NOMBRE_PAQUETE']; ?></h2>
                                <span class="badge bg-warning text-dark fs-6 px-3 py-2">
                                    <i class="far fa-clock"></i> <?php echo $row['DURACION_DIAS']; ?> Días
                                </span>
                            </div>
                            
                            <p class="card-text text-muted fs-5"><?php echo $row['DESCRIPCION_IA']; ?></p>
                            
                            <div class="mb-3">
                                <small class="text-muted me-3"><i class="fas fa-map-marker-alt text-danger"></i> <?php echo $row['DESTINO_PRINCIPAL']; ?></small>
                                <small class="text-muted"><i class="fas fa-tag text-primary"></i> <?php echo $row['CATEGORIA_VIAJE']; ?></small>
                            </div>

                            <hr>

                            <div class="mt-4 text-end">
                                <a href="detalle.php?id=<?php echo $row['ID_PAQUETE']; ?>" class="btn btn-outline-secondary rounded-pill px-4 me-2">Ver Detalles</a>
                                <button class="btn btn-primary rounded-pill px-5 fw-bold shadow-sm">Reservar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php 
            } // Fin del While
        } else {
            echo "<div class='alert alert-info text-center'>No hay tours disponibles en este momento.</div>";
        }
        ?>

    </section>

<?php include 'footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>